window.FILAMENT = {
    template: '<div id="flmntChatbot" class="flmntChatbot"><div onclick="FILAMENT.toggleBot();" id="flmntClickElement" class="flmntClickElement"><h3 id="flmntChatbotTitle" class="flmntChatbotTitle"></h3><img src="" class="flmntChatDecorationIcon" id="flmntChatDecorationIcon" alt="Speech bubbles"><svg class="flmntChatTabIcon" id="flmntChatTabMax" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M464 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zm0 394c0 3.3-2.7 6-6 6H54c-3.3 0-6-2.7-6-6V192h416v234z"></path></svg><svg class="flmntChatTabIcon" id="flmntChatTabMin" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M464 352H48c-26.5 0-48 21.5-48 48v32c0 26.5 21.5 48 48 48h416c26.5 0 48-21.5 48-48v-32c0-26.5-21.5-48-48-48z"></path></svg></div><div class="flmntChatIframeContainer" style="background:#FFF;"><iframe src="" frameborder="0" id="flmntChatIframe" class="flmntChatIframe"></iframe></div></div>',
    widgetCSS: function() {
        var css = '.flmntChatbot{max-height:520px;height:95%;width:300px;min-width:240px;z-index:999999;position:fixed;right:24px;box-shadow:rgba(0,0,0,.1) 0 1px 24px;border-radius:8px 8px 0 0}.flmntClickElement{padding:12px;background:#DA202A;color:#FFF;border-radius:8px 8px 0 0;cursor:pointer;position:relative}.flmntChatbotTitle{margin:0;padding-left:55px;font-size:16px;color:#FFF;font-weight:400;font-family:chevin,Helvetica,Arial,Nimbus Sans L,sans-serif}.flmntChatIframeContainer{height:100%}.flmntChatIframe{width:100%;height:92%}.flmntChatTabIcon{width:16px;height:16px;fill:#F4F4F3;position:absolute;top:12px;right:12px}.flmntChatDecorationIcon{width:80px;height:57px;position:absolute;top:-20px;left:-20px}@media screen and (max-width:420px){.flmntChatbot{width:96%;right:6px}.flmntChatbotTitle{padding-left:65px}.flmntChatDecorationIcon{width:65px;height:46px;top:-10px;left:5px}}@media screen and (max-height:500px){.flmntChatIframe{height:91%}}@media screen and (max-height:400px){.flmntChatIframe{height:90%}}@media screen and (max-height:350px){.flmntChatIframe{height:88%}}@media screen and (max-height:300px){.flmntChatIframe{height:86%}}',
            head = document.head || document.getElementsByTagName('head')[0],
            style = document.createElement('style');
        style.type = 'text/css';
        style.appendChild(document.createTextNode(css));
        head.appendChild(style);
    },
    calcPosition: function() {
        var body = document.body,
            html = document.documentElement,
            chatbotHeight = document.getElementById('flmntChatbot').clientHeight,
            tabHeight = document.getElementById('flmntClickElement').clientHeight,
            hiddenPosition = tabHeight - chatbotHeight;
        return hiddenPosition;
    },
    toggleBot: function() {
        var chatbot = document.getElementById('flmntChatbot'),
            maximiseIcon = document.getElementById('flmntChatTabMax'),
            minimiseIcon = document.getElementById('flmntChatTabMin'),
            chatbotIframe = document.getElementById('flmntChatIframe'),
            hiddenPosition = window.FILAMENT.calcPosition();
        if (chatbot.style.bottom !== '0px') {
            chatbot.style.bottom = '0px';
            maximiseIcon.style.display = 'none';
            minimiseIcon.style.display = 'inline-block';
            if (chatbotIframe.className.indexOf('flmntChatIframe-maximised') == -1) {
                setTimeout(function() {
                    chatbotIframe.src = window.FILAMENT.widgetURL();
                    chatbotIframe.className += ' flmntChatIframe-maximised';
                }, 250);
            }
            if (window.utag) {
                utag.link({
                    botChatEvent: 'Click|Open',
                    botChatType: 'Tracking Assistant'
                });
            }

        } else {
            chatbot.style.bottom = hiddenPosition + 'px';
            maximiseIcon.style.display = 'inline-block';
            minimiseIcon.style.display = 'none';
            if (window.utag) {
                utag.link({
                    botChatEvent: 'Click|Close',
                    botChatType: 'Tracking Assistant'
                });
            }
        }
    },
    widgetParams: function() {
        var widgetElems = document.getElementById('flmntWidgetInit'),
            widgetParams = {};
        for (var i = 0; i < widgetElems.attributes.length; i++) {
            if (widgetElems.attributes[i].name.indexOf('flmnt-') == 0) {
                var param = widgetElems.attributes[i].name.split('flmnt-');
                widgetParams[param[1]] = encodeURIComponent(widgetElems.attributes[i].value);
            }
        }
        return widgetParams;
    },
    widgetURL: function() {
        var sessionParams = window.FILAMENT.widgetParams(),
            baseUrl = decodeURIComponent(sessionParams.widgeturl),
            queryString = '?',
            iframeUrl = baseUrl,
            variableParam = '';
        for (var variable in sessionParams) {
            if (sessionParams.hasOwnProperty(variable)) {
                if (Object.keys(sessionParams).indexOf(variable) > 0) {
                    queryString += '&';
                }
                variableParam = sessionParams[variable];
                queryString += (variable + '=' + variableParam);
            }
        }
        iframeUrl = (baseUrl + queryString);
        return iframeUrl;
    },
    widgetIcon: function() {
        var sessionParams = window.FILAMENT.widgetParams(),
            iconUrl = decodeURIComponent(sessionParams.widgeticonurl);
        return iconUrl;
    },
    refresh: function() {
        document.getElementById('flmntChatIframe').src = window.FILAMENT.widgetURL();
    },
    listenForMessages: function() {
        window.addEventListener("message", function(event) {
            if (event.data && event.data.flTagType) {
                if (event.data.flTagType === 'view' && window.utag && utag.view) {
                    utag.view(event.data.data);
                }

                if (event.data.flTagType === 'click' && window.utag && utag.link) {
                    utag.link(event.data.data);
                }
            }
        }, false);
    },
    init: function() {
        var sessionParams = window.FILAMENT.widgetParams();
        window.FILAMENT.widgetCSS();
        window.FILAMENT.listenForMessages();
        document.body.insertAdjacentHTML('beforeend', window.FILAMENT.template);
        document.getElementById('flmntChatDecorationIcon').src = window.FILAMENT.widgetIcon();
        document.getElementById('flmntChatbotTitle').innerHTML = decodeURIComponent(sessionParams.widgettab);
        document.getElementById('flmntChatTabMin').style.display = 'none';
        document.getElementById('flmntChatbot').style.bottom = window.FILAMENT.calcPosition() + 'px';
    }
};

window.FILAMENT.init();

window.onresize = function() {
    var chatbot = document.getElementById('flmntChatbot'),
        maximiseIcon = document.getElementById('flmntChatTabMax'),
        minimiseIcon = document.getElementById('flmntChatTabMin');
    chatbot.style.bottom = window.FILAMENT.calcPosition() + 'px';
    maximiseIcon.style.display = 'inline-block';
    minimiseIcon.style.display = 'none';
};
